function [ze,Ge,Gg]=smith(Zs,Zc,Zg,d,f,epsr,a)
%
% function [ze,Ge,Gg]=smith(Zs,Zc,Zg,d,f,epsr[,a])
%
% La funzione SMITH disegna sulla carta di Smith lo spostamento 
% lungo una linea con perdite at, corispondente ad una distanza
% d alla frequenza f, a partire dalla impedenza normalizzata 
% zs=rs+jxs fino all'impedenza ze=re+jxe
%
% Input
% Zs: impedenza di partenza [Ohm]
% Zc: impedenza caratteristica linea [Ohm]
% Zg: impedenza generatore [Ohm]
% d: distanza della sezione finale dalla sezione iniziale [m]
% f: frequenza [Hz]
% epsr: costante dielettrica relativa
% a: attenuazione delle linea in dB/km (parametro opzionale)
%
% Output
% ze: impedenza (o ammettenza) di arrivo normalizzata
% Ge: coefficiente di riflessione in tensione (o corrente) di arrivo rispetto alla linea
% Gg: coefficiente di riflessione in tensione (o corrente) di arrivo rispetto al generatore
%
% By C. Riva
% Data: 22.05.01
spirale=0;
menubar=1;
if menubar,
  set(0,'defaultfiguretoolbar','none','defaultfiguremenubar','figure');
else
  set(0,'defaultfiguretoolbar','none','defaultfiguremenubar','none');
end

%se non viene fornita l'attenuazione, la linea  senza perdite
if nargin<7,
  a=0;
end

%parte reale dell'impedenza di partenza normalizzata
rs=real(Zs/Zc);
%parte immaginaria dell'impedenza di partenza normalizzata
xs=imag(Zs/Zc);

%attenuazione in Np/m
at=a/8686;

%calcola la lunghezza d'onda
lambda=3e8/sqrt(epsr)/f;
%calcola la costante di fase
beta=2*pi/lambda;
%calcola la distanza normalizzata
dn=d/lambda;
if not(spirale),
  dn=dn-.5*fix(dn/.5)
end

%apri la finestra grafica a pieno schermo
close all;h=figure(1);set(h,'position',[1 29 1024 702]);
%definisci il rapporto di aspetto e i colori della finestra grafica
set(gca,'box','off','nextplot','add','Color',[0.8 0.8 0.8],'PlotBoxAspectRatio',[1 1 1],...
        'xcolor',[0.8 0.8 0.8],'ycolor',[0.8 0.8 0.8]);

%disegna la carta di Smith
tr=2*pi*(0:.01:1);
r=0;rr=1/(r+1);cr=1-rr;
plot(cr+rr*cos(tr),rr*sin(tr),'k-')
text(cr+rr*cos(tr(round(length(tr)/2)))+.02,0.04,num2str(r),'fontsize',13);
for i=[.2 .5 1 2 5],
  rr=1/(i+1);cr=1-rr;
  rx=1/i;cx=rx;
  tx=2*atan(i)*(0:.01:1);
  plot(1-rx*sin(tx),cx-rx*cos(tx),'k:',cr+rr*cos(tr),rr*sin(tr),'k:')
  plot(1-rx*sin(tx),-cx+rx*cos(tx),'k:')
  text(cr+rr*cos(tr(round(length(tr)/2)))+.02,0.04,num2str(i),'fontsize',13);
  if (i<1)&(i>0),
    text(1-rx*sin(tx(length(tx)))-.12,cx-rx*cos(tx(length(tx)))+.02,num2str(i),'fontsize',13);
    text(1-rx*sin(tx(length(tx)))-.15,-cx+rx*cos(tx(length(tx)))-.02,num2str(-i),'fontsize',13);
  end
  if i>=1,
    text(1-rx*sin(tx(length(tx)))+.03,cx-rx*cos(tx(length(tx)))+.05,num2str(i),'fontsize',13);
    text(1-rx*sin(tx(length(tx)))+.05,-cx+rx*cos(tx(length(tx)))-.05,num2str(-i),'fontsize',13);
  end
end
%disegna assi  del piano complesso gamma
plot([-1.2 1.2],[0 0],'color','k','linewidth',1);
plot([0 0],[-1.2 1.2],'color','k','linewidth',1);
text(1.05,-0.1,'Re[\Gamma]','fontsize',18);
text(-0.3,1.1,'Im[\Gamma]','fontsize',18);

%disegna il punto di partenza del movimento
rrs=1/(rs+1);
crs=1-rrs;
zs=rs+j.*xs;
Gs=(zs-1)./(zs+1);
plot(real(Gs),imag(Gs),'ob','markersize',12,'linewidth',1.5);
text(real(Gs)-.1,imag(Gs)+.1,'z_s','fontsize',18,'fontname','timesnewroman','color','b','fontangle','italic');

%disegna Gamma_s
xg=[0 real(Gs)];
yg=[0 imag(Gs)];
plot(xg,yg,'-k','linewidth',1.5);
%text(mean(xg),mean(yg),'\Gamma_s','fontname','timesnewroman','fontsize',18,'color','b');

%disegna il movimento da zs lungo d
lsn=[0:lambda/500:dn];
ls=linspace(0,d,length(lsn));
gld=Gs.*exp(-j*4*pi*lsn-2.*at.*ls);
plot(real(gld),imag(gld),'-b','linewidth',1.5)
xgd=mean([0 real(gld(length(gld)))]);
ygd=mean([0 imag(gld(length(gld)))]);
text(xgd,ygd-.09,'\Gamma_e','fontsize',18,'color','r','fontname','timesnewroman');
%disegna il Gamma_d
xg=[0 real(gld(length(gld)))];
yg=[0 imag(gld(length(gld)))];
plot(xg,yg,'-r','linewidth',1.5);
Ge=gld(length(gld));
ze=(1+Ge)/(1-Ge);
Ze=ze*Zc;
text(real(Ge),imag(Ge),'z_e','fontsize',18,'fontname','timesnewroman','color','r','fontangle','italic');
text(-1.6,1.15,['Z_s=',num2str(Zs,'%5.0f'),' \Omega'],'fontsize',14,'color','b');
text(-1.6,1.00,['Z_c=',num2str(Zc,'%5.0f'),' \Omega'],'fontsize',14,'color','b');
text(-1.6,0.85,['Z_g=',num2str(Zg,'%5.0f'),' \Omega'],'fontsize',14,'color','b');
text(-1.6,0.70,['z_s=',num2str(zs,'%5.3f')],'fontsize',14,'color','b');
text(-1.6,0.55,['\Gamma_s=',num2str(Gs,'%5.2f')],'fontsize',14,'color','b');
text(-1.6,0.40,['z_e=',num2str(ze,'%5.3f')],'fontsize',14,'color','r');
text(-1.6,0.25,['Z_e=',num2str(Ze,'%5.1f'),' \Omega'],'fontsize',14,'color','r');
text(-1.6,0.10,['\Gamma_e=',num2str(Ge,'%5.2f')],'fontsize',14,'color','r');
Gg=(Ze-Zg)/(Ze+Zg);
text(-1.6,-0.05,['\Gamma_g=',num2str(Gg,'%5.2f')],'fontsize',14,'color','r');
text(-1.6,-0.20,['|\Gamma_g|=',num2str(abs(Gg),'%5.2f')],'fontsize',14,'color','r');
text(-1.6,-0.20,['|\Gamma_g|=',num2str(abs(Gg),'%5.2f')],'fontsize',14,'color','r');

%fissa gli estremi degli assi
axis([-1.2 1.2 -1.2 1.2])
set(gca,'nextplot','replace');
set(gca,'position',[0 0.05 0.95 0.9]);

return
[Settings]
Mode=0
