function tl_R2014b

% Il programma LT disegna l'inviluppo e l'andamento della tensione in funzione del tempo e della
% coordinata longitudinale in una linea di trasmissione.
%
% By C. Riva
% Data: 11.I.16

global h1 fs
global outv r x l a f er sd invpgs 
global deltaY deltaX widX_button
global txt_sdt sd_slider txt_vx txt_vr txt_vl txt_va txt_vf txt_ver
global graph1 graph2 graph3 graph4 graph5 pausa

rflag=1;
xflag=1;
aflag=1;
fflag=1;
erflag=1;
lflag=1;
smithflag=1;

%definition of main window position
posX_m=0;posY_m=0.0365;widX_m=1;widY_m=0.9388;
%open main window

set(0,'defaultfiguretoolbar','none','defaultfiguremenubar','none');
h0=figure(1);
set(h0,'NumberTitle','off','Name','Propagazione in un linea di trasmissione (C.Riva)','Units','normalized','pos',[posX_m posY_m widX_m widY_m]);

%time initialization
t=0;
%out command initialization
outv=0;
%distance between slider in Y direction
deltaY=.03;
%distance between slider in X direction
deltaX=0.04;
%width of buttons
widX_button=0.12;
%height of button
widY_button=0.04;
%present, min and max values of Re[load normalized impedance]
x=0;x_min=-50;x_max=50;
%present, min and max values of Re[load normalized impedance]
r=1;r_min=0;r_max=50;
%font size
fs=11;
%generator potential
V0=1;

%position of text for Re[load normalized impedance]
posX_r=.04;posY_r=.05;widX_r=.3;widY_r=.026;
%position of value of Re[load normalized impedance]
posX_vr=posX_r+widX_r;posY_vr=posY_r;widX_vr=.06;widY_vr=widY_r;
%position of slider of Re[load normalized impedance]
posX_slr=posX_r;posY_slr=posY_r+deltaY;widX_slr=widX_r+widX_vr;widY_slr=0.025;
%write text box of Re[load normalized impedance]
txt_r=uicontrol('Parent',h0,'style','text','Units','normalized','pos',[posX_r posY_r widX_r widY_r], ...
                'BackgroundColor','white','ForegroundColor','black',...
                'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Left',...
                'String',' Re[Impedenza normalizzata del carico]: ');
              
%plot the slider of Re[load normalized impedance]
r_slider=uicontrol('style','slider','Units','normalized','pos',[posX_slr posY_slr widX_slr widY_slr], ...
                   'min',r_min,'max',r_max,'val',r,'SliderStep',[0.002 0.02],...
                   'CallBack',@r_c); 
%write the value of Re[load normalized impedance]
txt_vr=uicontrol('style','text','Units','normalized',...
                 'pos',[posX_vr posY_vr widX_vr widY_vr],...
                 'BackgroundColor','white','ForegroundColor','r',...
                 'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Right',...
                 'String',num2str(r,'%6.2f'));

%position of text for Im[load normalized impedance]
posX_x=posX_r+widX_r+widX_vr+deltaX;posY_x=posY_r;widX_x=widX_r;widY_x=widY_r;
%position of value of Im[load normalized impedance]
posX_vx=posX_x+widX_x;posY_vx=posY_x;widX_vx=widX_vr;widY_vx=widY_x;
%position of slider of Im[load normalized impedance]
posX_slx=posX_x;posY_slx=posY_x+deltaY;widX_slx=widX_x+widX_vx;widY_slx=widY_slr;
%write text box of Im[load normalized impedance]
txt_x=uicontrol('style','text','Units','normalized','pos',[posX_x posY_x widX_x widY_x], ...
                'BackgroundColor','white','ForegroundColor','black',...
                'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Left',...
                'String',' Im[Impedenza normalizzata del carico]: ');
%plot the slider of Re[load normalized impedance]
x_slider=uicontrol('style','slider','Units','normalized','pos',[posX_slx posY_slx widX_slx widY_slx], ...
                   'min',x_min,'max',x_max,'val',x,'SliderStep',[0.001 0.01],...
                   'CallBack',@x_c);

%open axes for Smith's chart
posX_s=posX_r+2.*(widX_r+widX_vr+deltaX);posY_s=posY_r+widY_button+deltaY;widX_s=widX_button;widY_s=widX_s.*1.5;
pos_s=[posX_s posY_s widX_s widY_s];
h1=axes('parent',h0,'position',pos_s);
if not(smithflag==0),
  smith(r,x,h1);
end

%write the value of Re[load normalized impedance]
txt_vx=uicontrol('style','text','Units','normalized',...
                 'pos',[posX_vx posY_vx widX_vx widY_vx],...
                 'BackgroundColor','white','ForegroundColor','r',...
                 'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Right',...
                 'String',num2str(x,'%6.2f'));

%position of text for the length of the transmission line
posX_l=posX_r;posY_l=posY_slr+1.5.*deltaY;widX_l=widX_r-.015;widY_l=widY_r;
%position of value of  the length of the transmission line
posX_vl=posX_l+widX_l;posY_vl=posY_l;widX_vl=widX_vr+.015;widY_vl=widY_l;
%position of slider of  the length of the transmission line
posX_sll=posX_l;posY_sll=posY_l+deltaY;widX_sll=widX_l+widX_vl;widY_sll=widY_slr;
%write text box of  the length of the transmission line
txt_l=uicontrol('style','text','Units','normalized','pos',[posX_l posY_l widX_l widY_l],...
                'BackgroundColor','white','ForegroundColor','black',...
                'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Left',...
                'String',' Lunghezza linea [m]: ');
%present, min and max values of  the length of the transmission line
l=5;l_min=1;l_max=100;
%plot the slider of  the length of the transmission line
l_slider = uicontrol('style','slider','Units','normalized','pos',[posX_sll posY_sll widX_sll widY_sll], ...
                     'min',l_min,'max',l_max,'val',l,'SliderStep',[0.001 0.01],...
                     'CallBack',@l_c); 
%write the value of  the length of the transmission line
txt_vl=uicontrol('style','text','Units','normalized',...
                 'pos',[posX_vl posY_vl widX_vl widY_vl],...
                 'BackgroundColor','white','ForegroundColor','r',...
                 'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Right',...
                 'String',num2str(l,'%4.2f'));

%position of text for attenuation
posX_a=posX_x;posY_a=posY_slx+1.5.*deltaY;widX_a=widX_r-.015;widY_a=widY_r;
%position of value of attenuation
posX_va=posX_a+widX_a;posY_va=posY_a;widX_va=widX_vr+.015;widY_va=widY_a;
%position of slider of attenuation
posX_sla=posX_a;posY_sla=posY_a+deltaY;widX_sla=widX_a+widX_va;widY_sla=widY_slr;
%write text box of attenuation
txt_a=uicontrol('style','text','Units','normalized','pos',[posX_a posY_a widX_a widY_a],...
                'BackgroundColor','white','ForegroundColor','black',...
                'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Left',...
                'String',' Attenuazione [dB/km]: ');
%present, min and max values of attenuation
a=0;a_min=0;a_max=200;
%plot the slider of attenuation
a_slider = uicontrol('style','slider','Units','normalized','pos',[posX_sla posY_sla widX_sla widY_sla], ...
                     'min',a_min,'max',a_max,'val',a,'SliderStep',[0.005 0.05],...
                     'CallBack',@a_c); 
%write the value of attenuation
txt_va=uicontrol('style','text','Units','normalized',...
                 'pos',[posX_va posY_va widX_va widY_va],...
                 'BackgroundColor','white','ForegroundColor','r',...
                 'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Right',...
                 'String',num2str(a,'%4.2f'));

%position of text for frequency
posX_f=posX_r;posY_f=posY_sla+1.5.*deltaY;widX_f=widX_r-0.025;widY_f=widY_r;
%position of value of frequency
posX_vf=posX_f+widX_f;posY_vf=posY_f;widX_vf=widX_vr+0.025;widY_vf=widY_f;
%position of slider of frequency
posX_slf=posX_f;posY_slf=posY_f+deltaY;widX_slf=widX_f+widX_vf;widY_slf=widY_slr;
%write text box of frequency
txt_f=uicontrol('style','text','Units','normalized','pos',[posX_f posY_f widX_f widY_f],...
                'BackgroundColor','white','ForegroundColor','black',...
                'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Left',...
                'String',' Frequenza [MHz]: ');
%present, min and max values of attenuation
f=300e6;f_min=100e6;f_max=1000e6;
%plot the slider of frequency
f_slider = uicontrol('style','slider','Units','normalized','pos',[posX_slf posY_slf widX_slf widY_slf], ...
                     'min',f_min,'max',f_max,'val',f,'SliderStep',[1/900 10/900],...
                     'CallBack',@f_c); 
%write the value of attenuation
txt_vf=uicontrol('style','text','Units','normalized',...
                 'pos',[posX_vf posY_vf widX_vf widY_vf],...
                 'BackgroundColor','white','ForegroundColor','r',...
                 'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Right',...
                 'String',num2str(round(f./1e6),'%4d'));

%position of text for dielectric constant
posX_er=posX_x;posY_er=posY_sla+1.5.*deltaY;widX_er=widX_r-.015;widY_er=widY_r;
%position of value of dielectric constant
posX_ver=posX_er+widX_er;posY_ver=posY_er;widX_ver=widX_vr+.015;widY_ver=widY_er;
%position of slider of dielectric constant
posX_sler=posX_er;posY_sler=posY_er+deltaY;widX_sler=widX_er+widX_ver;widY_sler=widY_slr;
%write text box of dielectric constant
txt_er=uicontrol('style','text','Units','normalized','pos',[posX_er posY_er widX_er widY_er],...
                 'BackgroundColor','white','ForegroundColor','black',...
                 'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Left',...
                 'String',' Costante dielettrica relativa: ');
%present, min and max values of dielectric constant
er=1;er_min=1;er_max=10;
%plot the slider of dielectric constant
er_slider = uicontrol('style','slider','Units','normalized','pos',[posX_sler posY_sler widX_sler widY_sler], ...
                      'min',er_min,'max',er_max,'val',er,'SliderStep',[0.1./9 1./9],...
                      'CallBack',@er_c);
%write the value of dielectric constant
txt_ver=uicontrol('style','text','Units','normalized',...
                  'pos',[posX_ver posY_ver widX_ver widY_ver],...
                  'BackgroundColor','white','ForegroundColor','r',...
                  'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Right',...
                  'String',num2str(er,'%4.1f'));

%initialization of graphs' choice
graph1=0;graph2=0;graph3=0;graph4=0;graph5=0;pausa=0;
%position of buttons for graphs choice
deltaX_leg=0.01;posX_leg=posX_r-0.01;posY_leg=1-2.5.*deltaY;widX_leg=0.15;widY_leg=0.05;
%position of value of buttons for graphs choice
txt_leg=uicontrol('style','togglebutton','value',0,'Units','normalized','pos',[posX_leg posY_leg widX_leg widY_leg],...
                  'ForegroundColor','k',...
                  'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Center',...
                  'String','Onda progressiva','CallBack',@ob_leg1);
posX_leg=posX_leg+widX_leg+deltaX_leg;
txt_leg=uicontrol('style','togglebutton','Units','normalized','pos',[posX_leg posY_leg widX_leg widY_leg],...
                  'ForegroundColor','m',...
                  'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Center',...
                  'CallBack',@ob_leg2,'String','Onda regressiva');
posX_leg=posX_leg+widX_leg+deltaX_leg;
txt_leg=uicontrol('style','togglebutton','Units','normalized','pos',[posX_leg posY_leg widX_leg widY_leg],...
                  'ForegroundColor','b',...
                  'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Center',...
                  'CallBack',@ob_leg3,'String','Tensione totale');
posX_leg=posX_leg+widX_leg+deltaX_leg;widX_leg=0.24;
txt_leg=uicontrol('style','togglebutton','Units','normalized','pos',[posX_leg posY_leg widX_leg widY_leg],...
                  'ForegroundColor','b',...
                  'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Center',...
                  'CallBack',@ob_leg4,'String','o Tensione in generica sezione');
posX_leg=posX_leg+widX_leg+deltaX_leg;widX_leg=0.1;
txt_leg=uicontrol('style','togglebutton','Units','normalized','pos',[posX_leg posY_leg widX_leg widY_leg],...
                  'ForegroundColor','r',...
                  'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Center',...
                  'CallBack',@ob_leg5,'String','Inviluppo');
posX_leg=posX_leg+widX_leg+deltaX_leg;widX_leg=0.1;
txt_leg=uicontrol('style','togglebutton','Units','normalized','pos',[posX_leg posY_leg widX_leg widY_leg],...
                  'ForegroundColor','k',...
                  'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','Center',...
                  'CallBack',@ob_leg6,'String','Pause');
                
%position of out button 
posX_ob=posX_x+widX_x+widX_vx+deltaX;posY_ob=posY_r;widX_ob=widX_button;widY_ob=widY_button;
%plot the out button
ob_button=uicontrol('Style','pushbutton','Units','normalized','pos',[posX_ob posY_ob widX_ob widY_ob],...
                    'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','center',...
                    'CallBack',@ob_c,'String','exit');

%open axes for circuit
posX_circ=2.*posX_r;posY_circ=0.85-2.*posY_r;widX_circ=1-3.*posX_r;widY_circ=.15;
pos_circ=[posX_circ posY_circ widX_circ widY_circ];
h2=axes('parent',h0,'position',pos_circ);
set(h2,'pos',pos_circ,'color',[0.8 0.8 0.8],'xcolor',[0.8 0.8 0.8],'ycolor',[0.8 0.8 0.8],'box','off','nextplot','add');
colcir='b';
plot(l.*[-0.03 1.03],[0 0],['-',colcir],l.*[-0.03 1.03],[1 1],['-',colcir],...
     [0 0 l l],[0 1 0 1],['o',colcir],...
     l.*[1.03 1.03],[1 0.75],['-',colcir],l.*[1.03 1.03],[0.25 0],['-',colcir],...
     l.*[-0.03 -0.03],[1 0.9],['-',colcir],l.*[-0.03 -0.03],[0.5 0],['-',colcir],...
     'parent',h2,'linewidth',1.5,'markersize',4);
rectangle('position',[l.*1.02 0.25 l.*0.02 0.5],'parent',h2,'linewidth',1.5,'edgecolor',colcir);
rectangle('position',[l.*-0.04 0.5 l.*0.02 0.4],'parent',h2,'linewidth',1.5,'edgecolor',colcir);
rectangle('position',[l.*-0.045 0.1 l.*0.03 0.3],'parent',h2,'curvature',[1 1],'linewidth',1.5,'edgecolor',colcir);
text(l.*1.05,0.5,'ZL','parent',h2,'color',colcir,'fontname','arial','fontsize',fs,'FontWeight','Demi');
text(l.*0.5,0.5,'Zc','parent',h2,'color',colcir,'fontname','arial','fontsize',fs,'FontWeight','Demi');
text(l.*-0.1,0.7,'Zg=Zc','parent',h2,'color',colcir,'fontname','arial','fontsize',fs,'FontWeight','Demi');
text(l.*-0.075,0.25,[num2str(2.*V0),'V'],'parent',h2,'color',colcir,'fontname','arial','fontsize',fs,'FontWeight','Demi');
set(h2,'xlim',[-0.1.*l 1.1.*l],'ylim',[-0.05 1.05]);

%open axes for plot
posX_p=2.*posX_r;posY_p=posY_slf+5.6.*deltaY;widX_p=1-3.*posX_r;widY_p=0.85-2.*posY_r-posY_p;
pos_p=[posX_p posY_p widX_p widY_p];
h3=axes('parent',h0,'position',pos_p);
% set(h3,'pos',pos_p,'linewidth',1.5,'fontname','arial','fontsize',14,'grid',':','xgrid','off','ygrid','off','box','on');
set(h3,'pos',pos_p,'linewidth',1.5,'fontname','arial','fontsize',14,'xgrid','off','ygrid','off','box','on');
set(h3,'nextplot','add');
%set(h0,'BackingStore','off');
xlabel('z [m]','parent',h3);
ylabel('tensione [V]','parent',h3);
set(h3,'xlim',[-0.1.*l 1.1.*l],'ylim',[-2.*V0 2.*V0]);
%set(h3,'xcolor',[0.8 0.8 0.8],'ycolor',[0.8 0.8 0.8],'color',[0.8 0.8 0.8]);
%rectangle('parent',h3,'position',[-0.1.*l -2.*V0 1.2.*l 4.*V0],'edgecolor','r','linewidth',1.5);
%grx=[-0.1.*l -0.1.*l -0.1.*l   0.*l   1.*l   2.*l   3.*l   4.*l   5.*l; ...
%      1.1.*l  1.1.*l  1.1.*l   0.*l   1.*l   2.*l   3.*l   4.*l   5.*l];
%gry=[ -1.*V0   0.*V0   1.*V0 -2.*V0 -2.*V0 -2.*V0 -2.*V0 -2.*V0 -2.*V0; ...
%      -1.*V0   0.*V0   1.*V0  2.*V0  2.*V0  2.*V0  2.*V0  2.*V0  2.*V0]; 
%line(grx,gry,'color','k','linestyle',':','parent',h3);

aux=0.058;
posX_slsd=posX_p+aux;posY_slsd=posY_slf+2.5.*deltaY;widX_slsd=widX_p-2*aux;widY_slsd=widY_slr;
sd=l/2;
%plot the slider of section distance
sd_slider=uicontrol('style','slider','Units','normalized','pos',[posX_slsd posY_slsd widX_slsd widY_slsd], ...
                    'min',0,'max',l,'val',sd,'SliderStep',[0.001 0.01],...
                    'CallBack',@sd_c);
%write the value of slider distance
widX_sdt=.5;
posX_sdt=posX_slsd+widX_slsd/2-widX_sdt/2;
posY_sdt=posY_slsd-deltaY;
widY_sdt=widY_vl;
%text with distance and value of the stationary wave at a generic section
txt_sdt=uicontrol('style','text','Units','normalized',...
                  'pos',[posX_sdt posY_sdt widX_sdt widY_sdt],...
                  'BackgroundColor',[0.8 0.8 0.8],'ForegroundColor','b',...
                  'FontName','Arial','FontSize',fs,'FontWeight','Demi','HorizontalAlignment','center',...
                  'String',['Distanza generica sezione:',num2str(sd,'%6.3f'),' [m]', ...
                            ' - Valore inviluppo: ',num2str(invpgs,'%4.2f'), ' [V]']);
set(sd_slider,'visible','off');
set(txt_sdt,'visible','off');

if rflag==0,
  txt_r.Visible='off';
  r_slider.Visible='off';
  txt_vr.Visible='off';
  r=1;
end
if xflag==0,
  txt_x.Visible='off';
  x_slider.Visible='off';
  txt_vx.Visible='off';
  x=1;
end
if aflag==0,
  txt_a.Visible='off';
  a_slider.Visible='off';
  txt_va.Visible='off';
  a=0;
end
if fflag==0,
  txt_f.Visible='off';
  f_slider.Visible='off';
  txt_vf.Visible='off';
  f=600e6;
end
if erflag==0,
  txt_er.Visible=off';
  er_slider.Visible='off';
  txt_ver.Visible='off';
  er=1;
end
if lflag==0,
  txt_l.Visible='off';
  l_slider.Visible='off';
  txt_vl.Visible='off';
  l=3;
end
if smithflag==0,
  h1.Visible='off';
end


spT=20;

while ~outv,
  T=1./f;
  delta=T./spT;
  t=t+delta;
  zL=r+j.*x;
  lam=3E8./f./sqrt(er);
  %attenuazione in Np/m
  alpha=a./8.686./1000;
  kappa=2.*pi./lam-j.*alpha;
  w=2.*pi.*f;
  spl=100;
  nl=10;
  deltaz=lam./spl;
  z=0:deltaz:l;
  vpiu=V0.*exp(-j.*kappa.*z);
  gammaL=(zL-1)./(zL+1);
  gammaz=gammaL.*exp(-2.*j.*kappa.*(z(length(z))-z));
  invp=abs(vpiu).*abs(1+gammaz);
  invn=-invp;
  v=real( vpiu.*(1+gammaz) .* exp(j.*w.*t));
  I=find(z>=sd);
  if not(isempty(I)),
    I=I(1);
  else
    I=length(z);
  end
  %I=fix(length(z)./2.7);
  vzs=v(I);
  invpgs=invp(I);
  vpt=real(vpiu .* exp(j.*w.*t));
  vmt=real(vpiu .* exp(j.*w.*t) .* gammaz);
  if graph1,
    if exist('h31'),
      clearpoints(h31);
      addpoints(h31,z,vpt);
    else
      h31=animatedline(z,vpt);
      set(h31,'parent',h3,'linewidth',1.5,'markersize',10);
      set(h31,'color','k');
    end
  else
    if exist('h31'),
      clearpoints(h31);
    end
  end
  if graph2,
    if exist('h32'),
      clearpoints(h32);
      addpoints(h32,z,vmt);
    else
      h32=animatedline(z,vmt);
      set(h32,'parent',h3,'linewidth',1.5,'markersize',10);
      set(h32,'color','m');
    end
  else
    if exist('h32'),
      clearpoints(h32);
    end
  end
  if graph3,
    if exist('h33'),
      clearpoints(h33);
      addpoints(h33,z,v);
    else
      h33=animatedline(z,v);
      set(h33,'parent',h3,'linewidth',1.5,'markersize',10);
      set(h33,'color','b');
    end
  else
    if exist('h33'),
      clearpoints(h33);
    end
  end
  if graph4,
    txt_sdt.String=['Distanza generica sezione:',num2str(sd,'%6.3f'),' [m]', ...
                    ' - Valore inviluppo: ',num2str(invpgs,'%4.2f'), ' [V]'];
    set(sd_slider,'visible','on');
    set(txt_sdt,'visible','on');
    if exist('h34a'),
      clearpoints(h34a);
      addpoints(h34a,[z(I) z(I)],[invn(I) invp(I)]);
      clearpoints(h34b);
      addpoints(h34b,z(I),vzs);
    else
      h34a=animatedline([z(I) z(I)],[invn(I) invp(I)]);
      set(h34a,'parent',h3,'linewidth',1.5,'markersize',10);
      set(h34a,'color','b');
      h34b=animatedline(z(I),vzs);
      set(h34b,'parent',h3,'linewidth',1.5,'markersize',10);
      set(h34b,'color','b','marker','o','markersize',10);
    end
  else
    set(sd_slider,'visible','off');
    set(txt_sdt,'visible','off');
    if exist('h34a'),
      clearpoints(h34a);
      clearpoints(h34b);
    end
  end
  if graph5,
    if exist('h35a'),
      clearpoints(h35a);
      addpoints(h35a,z,invp);
      clearpoints(h35b);
      addpoints(h35b,z,invn);
    else
      h35a=animatedline(z,invp);
      set(h35a,'parent',h3,'linewidth',1.5,'markersize',10);
      set(h35a,'color','r');
      h35b=animatedline(z,invn);
      set(h35b,'parent',h3,'linewidth',1.5,'markersize',10);
      set(h35b,'color','r');
    end
  else
    if exist('h35a'),
      clearpoints(h35a);
      clearpoints(h35b);
    end
  end
  set(h3,'xlim',[-0.1.*l 1.1.*l]);
  set(h3,'ylim',[-2.*V0 2.*V0]);
  drawnow
  pause(0.005)
  while pausa & ~outv,
    drawnow
  end
  %drawnow;
end

close all

end



function ob_c(hObject, eventdata, handles)

global outv 

outv=1;

end



function r_c(hObject, eventdata, handles)

global h1 r x fs txt_vr

r=round(hObject.Value*100)/100;
% r=round(get(gco,'value')*100)/100;
smith(r,x,h1);
txt_vr.String=num2str(r,'%6.2f');

end



function x_c(hObject, eventdata, handles)

global h1 r x fs txt_vx

x=round(hObject.Value.*100)./100;
% x=round(get(gco,'value').*100)./100
smith(r,x,h1);
txt_vx.String=num2str(x,'%6.2f');

end
               
               
               
function l_c(hObject, eventdata, handles)

global fs l invpgs sd
global txt_vl txt_sdt sd_slider 

l=round(get(gco,'value')*10)/10;
set(txt_vl,'String',num2str(l,'%4.2f'));
set(sd_slider,'max',l);
if l<sd,
  sd=l;
  set(sd_slider,'val',sd);
  set(txt_sdt,'String',['Distanza generica sezione:',num2str(sd,'%6.3f'),' [m]',' - Valore inviluppo: ',num2str(invpgs,'%4.2f'), ' [V]']);
end
    
end
               
               

function sd_c(hObject, eventdata, handles)

global fs invpgs sd txt_sdt sd_slider

sd=round(get(gco,'value')*1000)/1000;
set(txt_sdt,'String',['Distanza generica sezione:',num2str(sd,'%6.3f'),' [m]',' - Valore inviluppo: ',num2str(invpgs,'%4.2f'), ' [V]']);

end
               
               

function a_c(hObject, eventdata, handles)

global fs a txt_va

a=round(get(gco,'value')*100)/100;
set(txt_va,'String',num2str(a,'%4.2f'));

end



function f_c(hObject, eventdata, handles)

global fs f txt_vf

f=round(get(gco,'value'));
set(txt_vf,'String',num2str(round(f./1e6),'%4d'));

end



function er_c(hObject, eventdata, handles)

global fs er txt_ver

er=round(get(gco,'value')*10)/10;
set(txt_ver,'String',num2str(er,'%4.1f'));

end



function ob_leg1(hObject, eventdata, handles)

global graph1

graph1=~graph1;
% val=~source.Value;

end



function ob_leg2(hObject, eventdata, handles)

global graph2

graph2=~graph2;
% val=~source.Value;

end



function ob_leg3(hObject, eventdata, handles)

global graph3

graph3=~graph3;
% val=~source.Value;

end


function ob_leg4(hObject, eventdata, handles)

global graph4

graph4=~graph4;
% val=~source.Value;

end


function ob_leg5(hObject, eventdata, handles)

global graph5

graph5=~graph5;
% val=~source.Value;

end


function ob_leg6(hObject, eventdata, handles)

global pausa

pausa=~pausa;
% val=~source.Value;

end



function smith(rus,xus,h1)
% SMITH    Draws a Smith chart and sets hold to on so that you can plot the
%          reflection coefficient on top of it.

% This is a quick little hack that draws a simple Smith chart, a diagram
% that is very frequently used in high frequency engineering.  It maps
% the normalized impedance z to the reflection coefficient gamma:
% gamma = (z-1)/(z+1)  with z = r+i*x .

% You can customize the function by specifying the r=const and x=const lines
% you want to draw at the beginning of the corresponding loops.

% 3-13-95   Frank Wiedmann   wiedmann@com.enst.fr
plot([-1 1],[0 0],'k-','parent',h1);
set(h1,'box','off');
set(h1,'nextplot','add');
set(h1,'Color',[0.8 0.8 0.8]);
set(h1,'PlotBoxAspectRatio',[122.88 126.36 122.88]);
set(h1,'xcolor',[0.8 0.8 0.8]);
set(h1,'ycolor',[0.8 0.8 0.8]);

tr = 2*pi*(0:.01:1);
for r = [0 .2 .5 1 2 5]   % specify the r=const lines you want to draw
   rr = 1/(r+1);
   cr = 1-rr;
   if (r==1)|(r==0),
     plot(cr+rr*cos(tr),rr*sin(tr),'k-','parent',h1)
   else
     plot(cr+rr*cos(tr),rr*sin(tr),'k:','parent',h1)
   end
end
rrus = 1/(rus+1);
crus = 1-rrus;
plot(crus+rrus*cos(tr),rrus*sin(tr),'r','parent',h1,'linewidth',1.5)
 

for x = [.2 .5 1 2 5]     % specify the x=const lines you want to draw
   rx = 1/x;
   cx = rx;
   tx = 2*atan(x)*(0:.01:1);
   plot(1-rx*sin(tx),cx-rx*cos(tx),'k:','parent',h1)
   plot(1-rx*sin(tx),-cx+rx*cos(tx),'k:','parent',h1)
end
if xus~=0,
  rxus = 1/xus;
  cxus = rxus;
  txus = 2*atan(xus)*(0:.01:1);
  plot(1-rxus*sin(txus),cxus-rxus*cos(txus),'r','parent',h1,'linewidth',1.5);
else
  plot([-1 1],[0 0],'r','parent',h1,'linewidth',1.5);
end
z=rus+j.*xus;
gamma=(z-1)./(z+1);
plot(real(gamma),imag(gamma),'xb','parent',h1,'markersize',12,'linewidth',1.5);

set(h1,'nextplot','replace');

end
